library('deSolve')

# derivatives for the Lotka-Volterra model
LV_derivatives = function(t,N,parms)
    return(list(with(parms,r*N*(1-(A%*%N)/K))))

# parameterisation for four species
n = 4
parms = list(A=matrix(c(1   , 0   , 2.33, 1.21,
                          1.09, 1   , 0   , 0.51,
                          1.52, 0.44, 1   , 0.35,
                          0   , 1.36, 0.47, 1   ),n,n),
             r=c(1,0.72,1.53,1.27), K=rep(1,n))
N0 = c(0.5,0.5,0.5,0.5)

ts=seq(0,500,length.out=1000)

# run the differential equation solver to get time series
N_t = ode(N0,ts,LV_derivatives,parms=parms)
plot(N_t) 
